#version 330
#extension GL_EXT_gpu_shader4 : enable
// SHADE A DAY_2_6_2015Mod01.fsh  by cabbibo
//https://www.shadertoy.com/view/lll3zB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// ALL TAKEN FROM IQs AMAZING SITE / TUTORIALS / SHADERS:
// https://iquilezles.org/www/index.htm
// https://www.shadertoy.com/user/iq

// Specific shaders stolen from
// ROT FUNCTIONS  : https://www.shadertoy.com/view/XsSSzG


const float MAX_TRACE_DISTANCE = 20.0;           // max trace distance
const float INTERSECTION_PRECISION = .001;        // precision of the intersection
const int NUM_OF_TRACE_STEPS = 120;
	

const float pi = 3.14159;

vec4 spherePos[8];
vec3 sphereRot[8];


// ROTATION FUNCTIONS TAKEN FROM
//https://www.shadertoy.com/view/XsSSzG
mat3 xrotate(float t) {
	return mat3(1.0, 0.0, 0.0,
                0.0, cos(t), -sin(t),
                0.0, sin(t), cos(t));
}

mat3 yrotate(float t) {
	return mat3(cos(t), 0.0, -sin(t),
                0.0, 1.0, 0.0,
                sin(t), 0.0, cos(t));
}

mat3 zrotate(float t) {
    return mat3(cos(t), -sin(t), 0.0,
                sin(t), cos(t), 0.0,
                0.0, 0.0, 1.0);
}



float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float sdPlane( vec3 p )
{

    //float f = fbm( p.xy );
    //f *= fbm( p.yz );
    //f = 5. * smoothstep( abs(f) , 0.4 , 0.8 );
	return p.y;// + sin( p.x * 1. * p.z ) * .002; //- (f * .4); //(abs( f) * .3)/ max( 1. , pow( length( p ), 1.));

}



//----
// Camera Stuffs
//----
mat3 calcLookAtMatrix( in vec3 ro, in vec3 ta, in float roll )
{
    vec3 ww = normalize( ta - ro );
    vec3 uu = normalize( cross(ww,vec3(sin(roll),cos(roll),0.0) ) );
    vec3 vv = normalize( cross(uu,ww));
    return mat3( uu, vv, ww );
}

void doCamera( out vec3 camPos, out vec3 camTar, in float time, in float mouseX )
{
    float an = 0.3 + 10.0*mouseX;
	camPos = vec3(3.5*sin(an),1.0,3.5*cos(an));
    camTar = vec3(0.0,0.0,0.0);
}




// checks to see which intersection is closer
// and makes the y of the vec2 be the proper id
vec2 opU( vec2 d1, vec2 d2 ){
    
	return (d1.x<d2.x) ? d1 : d2;
    
}

// exponential smooth min (k = 32);
float smin( float a, float b, float k ){
    
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
    
}

float opBlend( vec2 d1, vec2 d2 ){

    return smin( d1.x , d2.x , 8.);
    
}


mat3 fullRotate( vec3 r ){
 
   return xrotate( r.x ) * yrotate( r.y ) * zrotate( r.z );
    
}

float rotatedBox( vec3 p , vec3 rot , vec3 size , float rad ){
    
    vec3 q = fullRotate( rot ) * p;
    return udRoundBox( q , size , rad );
    
    
}


float rotatedPlane( vec3 p , vec3 rot ){
    
    vec3 q = fullRotate( rot ) * p;
    return sdPlane( q );

    
}


//--------------------------------
// Modelling 
//--------------------------------
vec2 map( vec3 pos ){  
    
   	//vec2 res = vec2( sdPlane( pos - vec3( 0. , -1. , 0. )), 0.0 );
    
    vec2 res = vec2( rotatedPlane( pos - vec3( 0. , -2. , 0. ) , vec3(.9 , 0. , 0)) , 0.);
    
    res.x = opBlend( res , vec2( rotatedPlane( pos - vec3( 0. , -2. , 0. ) , vec3(-.7 , 0. , 0)) , 0.));
    res.x = opBlend( res , vec2( rotatedPlane( pos - vec3( 0. , -2. , 0. ) , vec3(0. , 0. , 1.)) , 0.));
    //vec2 res = vec2( sdSphere( pos , 8. ) , 0.); , 1.
   
    for( int i = 0; i < 8; i++ ){
   		

        vec3 rot = sphereRot[i];
        vec3 p = pos- spherePos[i].xyz;
        vec3 s = vec3( spherePos[i].w );
        float r = spherePos[i].w / 3.;
        
        float intersection = rotatedBox( p , rot , s , r );
      	vec2 res2 = vec2( intersection , float(i) + 1.);
       	res.x = opBlend( res ,  res2 );
        
   	}
    

   	return res;
    
}


// Calculates our intersection by stepping through the
// map function, and returning both the object hit and the distance
// it is hit at
vec2 calcIntersection( in vec3 ro, in vec3 rd ){

    
    float h =  INTERSECTION_PRECISION*2.0;
    float t = 0.0;
	float res = -1.0;
    float id = -1.;
    
    for( int i=0; i< NUM_OF_TRACE_STEPS ; i++ ){
        
        if( h < INTERSECTION_PRECISION || t > MAX_TRACE_DISTANCE ) break;
	   	vec2 m = map( ro+rd*t );
        h = m.x;
        t += h;
        id = m.y;
        
    }

    if( t < MAX_TRACE_DISTANCE ) res = t;
    if( t > MAX_TRACE_DISTANCE ) id =-1.0;
    
    return vec2( res , id );
    
}

// Calculates the normal by taking a very small distance,
// remapping the function, and getting normal for that
vec3 calcNormal( in vec3 pos ){
    
	vec3 eps = vec3( 0.001, 0.0, 0.0 );
	vec3 nor = vec3(
	    map(pos+eps.xyy).x - map(pos-eps.xyy).x,
	    map(pos+eps.yxy).x - map(pos-eps.yxy).x,
	    map(pos+eps.yyx).x - map(pos-eps.yyx).x );
	return normalize(nor);
}


float softshadow( in vec3 ro, in vec3 rd, in float mint, in float tmax )
{
	float res = 1.0;
    float t = mint;
    for( int i=0; i<50; i++ )
    {
		float h = map( ro + rd*t ).x;
        res = min( res, 20.*h/t );
        t += clamp( h, 0.02, 0.10 );
        if( h<0.001 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );

}


float calcAO( in vec3 pos, in vec3 nor )
{
	float occ = 0.0;
    float sca = 1.0;
    for( int i=0; i<5; i++ )
    {
        float hr = 0.01 + 0.612*float(i)/4.0;
        vec3 aopos =  nor * hr + pos;
        float dd = map( aopos ).x;
        occ += -(dd-hr)*sca;
        sca *= 0.5;
    }
    return clamp( 1.0 - 3.0*occ, 0.0, 1.0 );    
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   for( int i =0; i < 8; i++ ){
        
        float x = 1. * cos(iTime *.13 * (float( i )+2.));
        float y = 1. * sin(iTime * .075 * (float( i )+4.));
        float z = 1. * sin(iTime * .1 * (float( i )+3.3));
        float r = .1 * ( sin( iTime * .1  *( float( i) +1.))+2.);
        
        spherePos[i] = vec4( x , y , z , r );
        
        
        sphereRot[i] = vec3( 
            (sin( iTime  * (float(i)+2.) * .4)) ,
            (sin( iTime  * (float(i)+8.2) * .2)) ,
            (sin( iTime  * (float(i)+3.6) * .01))
        );

    }

    vec2 p = (-iResolution.xy + 2.0*gl_FragCoord.xy)/iResolution.y;
    //vec2 m = iMouse.xy/iResolution.xy;
    vec2 m = vec2( 1.1 +( sin( iTime * 0.4 ) + sin( iTime * 0.01 )) * .04 , 0. );

    //-----------------------------------------------------
    // camera
    //-----------------------------------------------------
    
    // camera movement
    vec3 ro, ta;
    doCamera( ro, ta, iTime, m.x );

    // camera matrix
    mat3 camMat = calcLookAtMatrix( ro, ta, 0.0 );  // 0.0 is the camera roll
    
	// create view ray
	vec3 rd = normalize( camMat * vec3(p.xy,1.5 + abs(sin( iTime * .01 ) + sin( iTime * .0315 ))) ); // 2.0 is the lens length
    
    vec2 res = calcIntersection( ro , rd  );
    
    
  //  vec3 pat = texCube( iChannel0, 0.5*pos, nor, 10.0 ).xyz;
    vec3 col = vec3( 0. );//vec3( .8 , .8 , .8 ); 
   
    //vec3 col = texCube( iChannel0, ro + rd * 1. , rd , 1.0 ).xyz;
    // If we have hit something lets get real!
    if( res.y > -.5 ){

    	vec3 pos = ro + rd * res.x;
    	vec3 nor = calcNormal( pos );
        
        float AO = calcAO( pos , normalize(nor) );
        
        float match = -dot( normalize(nor) , rd );
        

        vec3 pat = vec3(1. , 0. , 0. ) * match * AO;//(vec3( 1. , 0. , 0. ) * (vec3( fbm( vec2(match * 10. , AO * 10.) )))) * .5;

        col += pow((1.- match),10.) * vec3( 1. , .9 , 0.);
        col += pow(( 1.-AO) , 2.)* vec3( 0. , .5, 1. );
        col += pat;// * .4 * ( nor * .5 + .5 );
        
       // col *= vec3( res.y );//vec3( 0. , 1. * sin( res.y *1000.+ 1. ) , 0.);
       /* if( res.y < .5 ){
            
            float f = sin( pos.z * 5. ) * sin( pos.x * 5. );
            //col *= 5. * smoothstep( abs(f) , 0.4 , 0.8 );
            col *= abs( f );
            col /= pow( length( pos ), 4.);
        }*/
    }
    
    // apply gamma correction
    col = pow( col, vec3(0.4545) );

    gl_FragColor = vec4( col , 1. );
    
}
